/*
 * Decompiled with CFR 0.152.
 */
package ecrans;

import ecrans.EcranResultats;
import elements.Ensemble;
import elements.Participant;
import elements.Resultats;
import exceptions.AnnulationException;
import filtre.Filtre;
import filtre.FiltreSexe;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ressources.Images;

public class Classements
extends JPanel
implements ActionListener,
ChangeListener,
Filtre {
    private static final long serialVersionUID = 1L;
    private final EcranResultats r;
    private final JComboBox type;
    private final JComboBox equipe;
    private final JSpinner nbr;
    private final JPanel val;
    private Filtre filtre;
    private boolean b;

    public Classements(EcranResultats r) {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.r = r;
        this.val = new JPanel(new GridLayout(2, 2));
        this.val.setOpaque(false);
        this.val.add(new JLabel("Colonne pour le classement par groupe : ", Images.getIcone("divers/affiche.png", 16), 0));
        this.equipe = new JComboBox<Object>(r.getModele().getColonnes().toArray());
        this.val.add(this.equipe);
        this.add(new JLabel("Classement : ", Images.getIcone("divers/result.png", 16), 0));
        this.type = new JComboBox<String>(new String[]{"G\u00e9n\u00e9ral", "Masculin", "F\u00e9minin", "Points \u00e9quipes", "Classement \u00e9quipes (scolaire)", "Classement \u00e9quipes (UGSEL)"});
        this.add(this.type);
        this.val.add(new JLabel("Nombre de participants au classement d'\u00e9quipe", Images.getIcone("divers/icone.png", 16), 0));
        this.nbr = new JSpinner(new SpinnerNumberModel(5, 1, 1000, 1));
        this.val.add(this.nbr);
        try {
            this.equipe.setSelectedIndex(r.getModele().getIndexGroupe());
        }
        catch (AnnulationException annulationException) {
            // empty catch block
        }
        this.nbr.addChangeListener(this);
        this.type.addActionListener(this);
        this.equipe.addActionListener(this);
        this.remove(this.val);
    }

    public Ensemble getEquipes() {
        int place;
        HashMap map = new HashMap();
        int c = this.equipe.getSelectedIndex();
        try {
            place = this.r.getModele().getIndexClassement();
        }
        catch (AnnulationException e2) {
            place = 0;
        }
        if (c == -1) {
            return this.r.getModele();
        }
        for (Participant p : this.r.getModele().getListe()) {
            if (!map.containsKey(p.getChamp(c))) {
                map.put(p.getChamp(c), new ArrayList());
            }
            try {
                Integer.valueOf(p.getChamp(place));
                ((List)map.get(p.getChamp(c))).add(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Resultats[] res = new Resultats[map.size()];
        int i = 0;
        for (Map.Entry e : map.entrySet()) {
            res[i] = new Resultats(this.r.getModele().getNom(), true);
            int classement = 0;
            int n = 0;
            boolean ok = false;
            for (Participant p : (List)e.getValue()) {
                res[i].ajout(p);
                if (place != -1) {
                    try {
                        classement += Integer.valueOf(p.getChamp(place)).intValue();
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
                if (++n >= (Integer)this.nbr.getValue()) {
                    ok = true;
                }
                if (ok) break;
            }
            Participant pp = new Participant(new ArrayList<String>());
            pp.getChamps().add(ok ? "TOTAL : " + classement : "Equipe non class\u00e9e");
            res[i].setPoints(ok ? classement : Integer.MAX_VALUE);
            res[i].ajout(pp);
            ++i;
        }
        Arrays.sort(res, new Comparator<Resultats>(){

            @Override
            public int compare(Resultats o1, Resultats o2) {
                return new Integer(o1.getPoints()).compareTo(o2.getPoints());
            }
        });
        int j = 0;
        while (j < res.length) {
            if (!res[j].getListe().isEmpty() && res[j].getPoints() < Integer.MAX_VALUE) {
                res[j].getListe().get(res[j].getListe().size() - 1).getChamps().add("CLASSEMENT : " + (j + 1));
            }
            ++j;
        }
        Resultats rs = new Resultats(this.r.getModele().getNom(), true);
        rs.setColonnes(this.r.getModele().getColonnes());
        Resultats[] resultatsArray = res;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            Resultats r = resultatsArray[n2];
            ArrayList<String> a = new ArrayList<String>();
            boolean team = false;
            rs.ajout(new Participant(a));
            for (Participant p : r.getListe()) {
                if (!team) {
                    if (this.equipe.getSelectedIndex() == -1) {
                        a.add("EQUIPE");
                    } else {
                        a.add("Equipe " + p.getChamp(this.equipe.getSelectedIndex()));
                    }
                    team = true;
                }
                rs.ajout(p);
            }
            ArrayList<String> aa = new ArrayList<String>();
            aa.add(" ");
            rs.ajout(new Participant(aa));
            ++n2;
        }
        return rs;
    }

    public Ensemble getClassementEquipes() {
        HashMap map = new HashMap();
        int c = this.equipe.getSelectedIndex();
        if (c == -1) {
            return this.r.getModele();
        }
        int place = this.getIndexPlace();
        if (c == -1) {
            return this.r.getModele();
        }
        for (Participant p : this.r.getModele().getListe()) {
            if (!map.containsKey(p.getChamp(c))) {
                map.put(p.getChamp(c), new ArrayList());
            }
            try {
                Integer.valueOf(p.getChamp(place));
                ((List)map.get(p.getChamp(c))).add(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Resultats[] res = new Resultats[map.size()];
        int i = 0;
        for (Map.Entry e : map.entrySet()) {
            res[i] = new Resultats(this.r.getModele().getNom(), true);
            int classement = 0;
            int n = 0;
            boolean ok = false;
            for (Participant p : (List)e.getValue()) {
                res[i].ajout(p);
                if (place != -1) {
                    try {
                        classement += Integer.valueOf(p.getChamp(place)).intValue();
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
                if (++n >= (Integer)this.nbr.getValue()) {
                    ok = true;
                }
                if (ok) break;
            }
            Participant pp = new Participant(new ArrayList<String>());
            pp.getChamps().add(ok ? "TOTAL : " + classement : "Equipe non class\u00e9e");
            res[i].setPoints(ok ? classement : Integer.MAX_VALUE);
            res[i].ajout(pp);
            ++i;
        }
        Arrays.sort(res, new Comparator<Resultats>(){

            @Override
            public int compare(Resultats o1, Resultats o2) {
                return new Integer(o1.getPoints()).compareTo(o2.getPoints());
            }
        });
        Resultats r = new Resultats("Classement equipes " + this.r.getModele().getNom(), true);
        r.getColonnes().add("Classement");
        r.getColonnes().add("Equipe");
        r.getColonnes().add("Points");
        int j = 0;
        while (j < res.length) {
            Participant p = new Participant(new ArrayList<String>());
            p.getChamps().add(res[j].getPoints() == Integer.MAX_VALUE ? "Non class\u00e9e" : String.valueOf(j + 1));
            p.getChamps().add(res[j].getListe().isEmpty() ? "Equipe non class\u00e9e" : res[j].getListe().get(0).getChamp(c));
            p.getChamps().add(res[j].getPoints() == Integer.MAX_VALUE ? " " : String.valueOf(res[j].getPoints()));
            r.ajout(p);
            ++j;
        }
        return r;
    }

    public int getIndexPlace() {
        try {
            return this.r.getModele().getIndexClassement();
        }
        catch (AnnulationException e2) {
            return 0;
        }
    }

    public Ensemble getClassementEquipesUgsel() {
        HashMap map = new HashMap();
        int c = this.equipe.getSelectedIndex();
        if (c == -1) {
            return this.r.getModele();
        }
        final int place = this.getIndexPlace();
        for (Participant p : this.r.getModele().getListe()) {
            try {
                Integer.valueOf(p.getChamp(place));
                if (!map.containsKey(p.getChamp(c))) {
                    map.put(p.getChamp(c), new ArrayList());
                }
                ((List)map.get(p.getChamp(c))).add(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<Resultats> res = new ArrayList<Resultats>();
        for (Map.Entry e : map.entrySet()) {
            if (((List)e.getValue()).size() < 4) continue;
            Resultats rs = new Resultats(this.r.getModele().getNom(), true);
            int classement = 0;
            int remaining = ((List)e.getValue()).size();
            for (Participant p : (List)e.getValue()) {
                --remaining;
                rs.ajout(p);
                if (rs.getListe().size() < 5) {
                    try {
                        classement += Integer.valueOf(p.getChamp(place)).intValue();
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
                if (rs.getListe().size() < 5 && (remaining != 0 || rs.getListe().size() < 4)) continue;
                Participant pp = new Participant(new ArrayList<String>());
                pp.getChamps().add("TOTAL : " + classement);
                rs.setPoints(classement);
                rs.ajout(pp);
                res.add(rs);
                rs = new Resultats(this.r.getModele().getNom(), true);
                classement = 0;
            }
        }
        Collections.sort(res, new Comparator<Resultats>(){

            @Override
            public int compare(Resultats o1, Resultats o2) {
                int p2;
                int p1 = o1.getPoints();
                if (p1 == (p2 = o2.getPoints())) {
                    try {
                        p1 = Integer.valueOf(o1.getListe().get(3).getChamp(place));
                        p2 = Integer.valueOf(o2.getListe().get(3).getChamp(place));
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
                return new Integer(p1).compareTo(p2);
            }
        });
        Resultats r = new Resultats("Classement equipes " + this.r.getModele().getNom(), true);
        r.getColonnes().add("Classement");
        r.getColonnes().add("Equipe");
        r.getColonnes().add("Points");
        r.getColonnes().addAll(this.r.getModele().getColonnes());
        int classement = 0;
        for (Resultats rslt : res) {
            Participant p = new Participant(new ArrayList<String>());
            p.getChamps().add(String.valueOf(++classement));
            p.getChamps().add(rslt.getListe().get(0).getChamp(c));
            p.getChamps().add(String.valueOf(rslt.getPoints()));
            r.ajout(p);
            for (Participant prt : rslt.getListe()) {
                ArrayList<String> ls = new ArrayList<String>(prt.getChamps());
                ls.add(0, "");
                ls.add(0, "");
                ls.add(0, "");
                r.ajout(new Participant(ls));
            }
            r.ajout(new Participant(new ArrayList<String>()));
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    public Resultats nombre(Resultats r) {
        block1: {
            if ((Integer)this.nbr.getValue() != 0) ** GOTO lbl6
            r.getListe().clear();
            break block1;
lbl-1000:
            // 1 sources

            {
                r.getListe().remove(r.getListe().size() - 1);
lbl6:
                // 2 sources

                ** while (r.getListe().size() > ((Integer)this.nbr.getValue()).intValue())
            }
        }
        return r;
    }

    public void setResultat() {
        switch (this.type.getSelectedIndex()) {
            case 0: {
                this.filtre = null;
                this.r.setResultat(this.r.getBase());
                break;
            }
            case 1: {
                this.filtre = new FiltreSexe(false);
                this.r.setResultat(this.r.getBase());
                break;
            }
            case 2: {
                this.filtre = new FiltreSexe(true);
                this.r.setResultat(this.r.getBase());
                break;
            }
            case 3: {
                this.add(this.val);
                this.r.afficheResultat(this.getEquipes());
                this.nbr.setEnabled(true);
                this.b = true;
                break;
            }
            case 4: {
                this.add(this.val);
                this.r.afficheResultat(this.getClassementEquipes());
                this.nbr.setEnabled(true);
                this.b = false;
                break;
            }
            case 5: {
                this.add(this.val);
                this.r.afficheResultat(this.getClassementEquipesUgsel());
                this.nbr.setEnabled(false);
                this.b = false;
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.b) {
            this.r.afficheResultat(this.getEquipes());
        } else {
            this.r.afficheResultat(this.getClassementEquipes());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.remove(this.val);
        if (e.getSource() == this.type || e.getSource() == this.equipe) {
            this.setResultat();
        }
        this.validate();
        this.repaint();
    }

    @Override
    public boolean accepte(Ensemble modele, int ligne) {
        return this.filtre == null || this.filtre.accepte(modele, ligne);
    }
}

